/*****************************************************************/
/* Includes
/*****************************************************************/
#include <sstream>
#include <iostream>

#include "structsizer.h"

using namespace std;

/*****************************************************************/
/* Variables
/*****************************************************************/

/*****************************************************************/
/* Functions
/*****************************************************************/

string fGetSizeString(int iBytes) {
	stringstream lResult (stringstream::out);

	//lResult << "DATA SIZE: ";
	//under 5KB
	if (iBytes < 5 * 1024) {
		lResult << iBytes << " B";
	}
	//under 5MB
	else if (iBytes < 5 * 1024 * 1024) {
		lResult << iBytes / 1024 << "." << iBytes % 1024 << " KB";
	}
	//the rest
	else {
		lResult << iBytes / (1024 * 1024) << "." << (iBytes % (1024 * 1024)) / 1024 << " MB";
	}

	return lResult.str();
}

/*****************************************************************/
/* Class - constructors
/*****************************************************************/

/*****************************************************************/
/* Class - interface
/*****************************************************************/

/*****************************************************************/
/* Class - implementation
/*****************************************************************/
