from os.path import basename
from glob import glob
import numpy as np
import cv2 as cv


ratio = 12

# for i, filename in enumerate(glob('../original_data/frames/*.jpg')):
#     img = cv.imread(filename)
#     h, w, c = img.shape
#     new_h = h / ratio
#     new_w = w / ratio
#     img_resized = cv.resize(img, (new_w, new_h))
#     base_name = basename(filename)
#     cv.imwrite('frames/{}'.format(base_name), img_resized)


for filename in glob('../original_data/annotations/*.txt'):
    data = np.loadtxt(filename, delimiter=',')
    if len(data.shape) == 1:
        data = data.reshape((1, -1))
    base_name = basename(filename)
    with open('resized_annotations/{}'.format(base_name), 'w') as f:
        for line in data:
            new_line = '{},{},{}\n'.format(int(line[0] / ratio),
                                         int(line[1] / ratio),
                                         int(line[2]))
            f.write(new_line)
