#pragma once
class CameraCone
{
public:
	CameraCone(
		CapturingReality::CoordinateSystemPoint point,
		CapturingReality::CoordinateSystemPoint normal,
		CollisionDetector *ColDet,
		double minHeight,
		double safeRadius,
		double minShootDist,
		double MaxShootDist,
		double MaxViewAngle);
	~CameraCone();

	void GeneratePoints();

	std::vector<CapturingReality::CoordinateSystemPoint> getPoints();
	std::vector<CapturingReality::CoordinateSystemPoint> getAllPoints();

	std::vector<CapturingReality::CoordinateSystemPoint> getRandomPoints(int count);

	bool isColliding(CapturingReality::CoordinateSystemPoint C);

private:
	CollisionDetector *cd;
	int bitmapSize;
	std::vector<std::vector<CapturingReality::CoordinateSystemPoint>> points;
	std::vector<CapturingReality::CoordinateSystemPoint> all_points;
	bool** bitmap;
	CapturingReality::CoordinateSystemPoint *ortho, lookAt;
	// n = normal vector of the surface
	// v, u = orthogonal vectors to n
	double minHeight, radius, minDist, maxDist;

	double *M, *K;


	inline bool isInCircle(double c_center_x, double c_center_y, double radius, int x, int y) {
		return ((x - c_center_x) * (x - c_center_x) + (y - c_center_y) * (y - c_center_y)) <= radius * radius;
	}
	void gram_schimdt();
};

