#pragma once
class CollisionDetector
{
public:
	CollisionDetector(double _cell_size) {
		cell_size_x = _cell_size;
		cell_size_z = _cell_size;
	}

	HRESULT LoadModel(
		__in CapturingReality::Mvs::IMvsModel *pMvsModel,
		CapturingReality::CoordinateSystemResidual transform);
	
	bool SpherePointCollision(CapturingReality::CoordinateSystemPoint C, double radius);
	void CollisionDetector::GivePoints(
		std::vector<CapturingReality::CoordinateSystemPoint> &pts,
		std::vector<int> &ids);
	
	~CollisionDetector();

private:
	UINT x_size, z_size;
	double cell_size_x, cell_size_z;
	double x_max, x_min, z_min, z_max, x_range, z_range;


	std::vector<CapturingReality::CoordinateSystemPoint> Subdivide(
		const double maxTriangleSize,
		CapturingReality::CoordinateSystemPoint &t1,
		CapturingReality::CoordinateSystemPoint &t2,
		CapturingReality::CoordinateSystemPoint &t3);

	inline int MapX(double val) {
		return std::round((val - x_min)/(x_range) * (x_size-1));
	}
	inline int MapZ(double val) {
		return std::round((val - z_min)/(z_range) * (z_size-1));
	}

	inline double EuclideanDistance(CapturingReality::CoordinateSystemPoint point1, CapturingReality::CoordinateSystemPoint point2)
	{
		return sqrt(pow(point1.x - point2.x, 2) + pow(point1.y - point2.y, 2) + pow(point1.z - point2.z, 2));
	}

	inline CapturingReality::CoordinateSystemPoint Midpoint(CapturingReality::CoordinateSystemPoint point1, CapturingReality::CoordinateSystemPoint point2)
	{
		CapturingReality::CoordinateSystemPoint p;
		Vec3Add(&point1.x, &point2.x, &p.x);
		Vec3Scale(&p.x, 1.0 / 2.0);
		return p;
	}

	void CollisionDetector::RemoveDuplicates();

	std::vector<CapturingReality::CoordinateSystemPoint> **points; //2D space of vectors containing triangles
};

