#pragma once
std::vector<CapturingReality::CoordinateSystemPoint> FibonacciSphere(int ng, CapturingReality::CoordinateSystemPoint at, double scale)
{
	const double r8_pi = 3.141592653589793;

	double offset = 2.0 / ng;
	double increment = r8_pi * (3 - sqrt(5));
	double a, r, y;
	std::vector<CapturingReality::CoordinateSystemPoint> xyz;

	for (int i = 0; i < ng; i++)
	{
		CapturingReality::CoordinateSystemPoint p;
		y = ((i * offset - 1) + (offset / 2));
		r = sqrt(1 - y*y);
		a = ((i + 1) % ng) * increment;
		p.y = y * scale + at.y;
		p.x = cos(a) * r * scale + at.x;
		p.z = sin(a) * r * scale + at.z;
		xyz.push_back(p);
	}

	return xyz;
}