#include "stdafx.h"
#include "FloydWarshall.h"


FloydWarshall::FloydWarshall()
{
}


FloydWarshall::~FloydWarshall()
{
}

void FloydWarshall::solve(std::vector<std::vector<double>> &g)
{
	std::vector<std::vector<double>> edges;

	for (int u = 0; u < g.size(); u++) {
		for (int v = 0; v < g.size(); v++) {
			if (g[u][v] != INF) {
				std::vector<double> edge(3);
				edge[0] = u;
				edge[1] = v;
				edge[2] = g[u][v];
				edges.push_back(edge);
			}
		}
	}

	dist.resize(g.size());
	for (auto& dim : dist) {
		for (auto i = 0; i < g.size(); ++i) {
			dim.push_back(INF);
		}
	}
	for (auto& w : edges) {
		dist[w[0]][w[1]] = w[2];
	}
	next.resize(g.size());
	for (auto i = 0; i < g.size(); ++i) {
		for (auto j = 0; j < g.size(); ++j) {
			next[i].push_back(0);
		}
		for (auto j = 0; j < g.size(); ++j) {
			if (i != j) {
				next[i][j] = j;
			}
		}
	}
	int total = 0;
	for (auto k = 0; k < g.size(); ++k) {
		total++;
		printf("\rFloyd Warshall: vertex %d/%d", total, g.size());
		//#pragma omp parallel for
		for (auto i = 0; i < g.size(); ++i) {
			for (auto j = 0; j < g.size(); ++j) {
				if (dist[i][j] > dist[i][k] + dist[k][j]) {
					dist[i][j] = dist[i][k] + dist[k][j];
					next[i][j] = next[i][k];
				}
			}
		}
	}

	printf("\n");
}



double FloydWarshall::getCost(const int & u, const int & v)
{
	if (u < 0 || u >= dist.size() || v < 0 || v >= dist.size()) return INF;
	return dist[u][v];
}

std::vector<int> FloydWarshall::getPathIdx(const int & u, const int & v)
{
	std::vector<int> idxs;
	int u_, v_;
	u_ = u;
	v_ = v;

	idxs.push_back(u_);
	do {
		u_ = next[u_][v_];
		idxs.push_back(u_);
	} while (u_ != v_);

	return idxs;
}

std::vector<CapturingReality::CoordinateSystemPoint> FloydWarshall::getPath(const int & u, const int & v, std::vector<std::vector<std::vector<CapturingReality::CoordinateSystemPoint>>> &pths)
{
	std::vector<int> idxs = getPathIdx(u, v);
	std::vector<CapturingReality::CoordinateSystemPoint> pth;

	for (int i = 0; i < idxs.size()-1; i++) {
		pth.insert(pth.end(), pths[idxs[i]][idxs[i+1]].begin(), pths[idxs[i]][idxs[i + 1]].end());
	}

	return pth;
}