#include "stdafx.h"
#include "svd3d.h"
#include "PointCloudTransformation.h"


PointCloudTransformation::PointCloudTransformation(
	CapturingReality::Sfm::IStructureFromMotion * pSfm,
	CapturingReality::Sfm::ISfmReconstruction * pRec,
	std::vector<std::vector<CapturingReality::CoordinateSystemPoint>>& CameraPositions)
{
	R = new double[9];
	T = new double[3];

	CapturingReality::Sfm::ISfmCameraModel *pCameraModel = pRec->GetCameraModel();

	UINT camerasCount = pRec->GetCamerasCount();

	for (UINT i = 0; i < camerasCount; i++)
	{
		CapturingReality::SfmCamera camera;
		pRec->GetCamera(i, &camera);

		CapturingReality::Sfm::ISfmStreamInput *streamInput;
		pSfm->GetImage(camera.sfmImage, &streamInput);

		const wchar_t* file_name = streamInput->GetFileName();
		std::wstring ws(file_name);
		std::string str(ws.begin(), ws.end());

		UINT sim, img;
		GetMatchFromName(str, sim, img);
		sim--; // simulations start from num 1 (just to index right)

		double C[4];
		pCameraModel->GetCameraCentre(camera, C);
		camera.sfmImage;

		CapturingReality::CoordinateSystemPoint sfm_pos;
		sfm_pos.x = C[0] / C[3];
		sfm_pos.y = C[1] / C[3];
		sfm_pos.z = C[2] / C[3];
		sfmCameras.push_back(sfm_pos);

		CapturingReality::CoordinateSystemPoint orig_pos;
		orig_pos.x = CameraPositions[sim][img].x;
		orig_pos.y = CameraPositions[sim][img].y;
		orig_pos.z = CameraPositions[sim][img].z;
		cameras.push_back(orig_pos);
	}
}

void PointCloudTransformation::TransformPoints(std::vector<CapturingReality::CoordinateSystemPoint> &points)
{
	for (int i = 0; i < points.size(); i++) {

		CapturingReality::CoordinateSystemPoint tmp;

		Vec3Scale(&points[i].x, scale);
		MulM33V3(&R[0], &points[i].x, &tmp.x);
		Vec3Add(&tmp.x, &T[0], &points[i].x);
	}

}

void PointCloudTransformation::TransformPoint(CapturingReality::CoordinateSystemPoint & point)
{
	CapturingReality::CoordinateSystemPoint tmp;

	Vec3Scale(&point.x, scale);
	MulM33V3(&R[0], &point.x, &tmp.x);
	Vec3Add(&tmp.x, &T[0], &point.x);
}

void PointCloudTransformation::GetMatchFromName(
	std::string &image_name,
	UINT &sim,
	UINT &image)
{
	std::vector<char> parser;
	for (int i = image_name.size() - 4; i >= 0; i--)
	{
		if (image_name[i] == '_')
		{
			std::string img(parser.begin(), parser.end());
			image = std::stoi(img);
			parser.clear();
			continue;
		}

		if (image_name[i] == '\\')
		{
			std::string img(parser.begin(), parser.end());
			sim = std::stoi(img);
			break;
		}

		parser.insert(parser.begin(), image_name[i]);
	}
}

void PointCloudTransformation::CalculateTransformation()
{
	double orig_dist = 0;
	double sfm_dist = 0;

	int camerasCount = cameras.size(); //the two vectors are the same length

	for (UINT i = 0; i < camerasCount - 1; i++)
	{
		orig_dist += EuclideanDistance(cameras[i], cameras[i + 1]);
		sfm_dist += EuclideanDistance(sfmCameras[i], sfmCameras[i + 1]);
	}

	double scale_factor = orig_dist / sfm_dist;
	printf("\tScale factor: %f\n", scale_factor);

	CapturingReality::CoordinateSystemPoint orig_centroid = { 0 };
	CapturingReality::CoordinateSystemPoint sfm_centroid = { 0 };

	for (UINT i = 0; i < camerasCount; i++)
	{
		Vec3Add(&orig_centroid.x, &cameras[i].x, &orig_centroid.x);
		Vec3Scale(&sfmCameras[i].x, scale_factor);
		Vec3Add(&sfm_centroid.x, &sfmCameras[i].x, &sfm_centroid.x);
	}
	Vec3Scale(&orig_centroid.x, 1.0 / camerasCount);
	Vec3Scale(&sfm_centroid.x, 1.0 / camerasCount);

	CapturingReality::CoordinateSystemRigid transf = { 0 };
	CapturingReality::CoordinateSystemRigid tmp = { 0 };

	for (UINT i = 0; i < camerasCount; i++)
	{
		Vec3Sub(&cameras[i].x, &orig_centroid.x, &cameras[i].x);
		Vec3Sub(&sfmCameras[i].x, &sfm_centroid.x, &sfmCameras[i].x);
		Vec33TMult(&tmp.R[0], &sfmCameras[i].x, &cameras[i].x);
		Mat33Add(&transf.R[0], &tmp.R[0], &transf.R[0]);
	}

	double U[9] = {};
	double S[9] = {};
	double V[9] = {};
	
	svd3d svd; //SVD decomposition
	svd.run(transf.R, U, S, V);
	
	double UT[9] = {};
	Mat33Transpose(U, UT);
	Mat33Mul(V, UT, &transf.R[0]);
	
	MulM33V3(&transf.R[0], &sfm_centroid.x, &tmp.t[0]);
	Vec3Sub(&orig_centroid.x, &tmp.t[0], &transf.t[0]);
	
	std::vector<CapturingReality::CoordinateSystemPoint> orig;
	std::vector<CapturingReality::CoordinateSystemPoint> sfm;
	
	scale = scale_factor;

	R[0] = transf.R[0];
	R[1] = transf.R[1];
	R[2] = transf.R[2];
	R[3] = transf.R[3];
	R[4] = transf.R[4];
	R[5] = transf.R[5];
	R[6] = transf.R[6];
	R[7] = transf.R[7];
	R[8] = transf.R[8];

	T[0] = transf.t[0];
	T[1] = transf.t[1];
	T[2] = transf.t[2];
}
