#pragma once

class TSP
{
public:
	TSP(int size);
	~TSP();

	std::vector<size_t> getPath() {
		return best_path;
	};

	void TSP::setDistance(int u, int v, double dist);

	double answer = INF;
	std::vector<size_t> path;
	std::vector<size_t> best_path;


	double twooptsolve(size_t initial_vertex);

	void TSP::setPath(
		int u,
		int v,
		double dist,
		std::vector<CapturingReality::CoordinateSystemPoint> &path,
		std::vector<std::vector<std::vector<CapturingReality::CoordinateSystemPoint>>> &paths);

	void reduceToComponent(
		const int &initial_vertex,
		std::vector<std::vector<std::vector<CapturingReality::CoordinateSystemPoint>>> &pths,
		std::vector<CapturingReality::CoordinateSystemPoint> &cams,
		std::vector<CapturingReality::CoordinateSystemPoint> &lks);

	void fillPaths(std::vector<std::vector<std::vector<CapturingReality::CoordinateSystemPoint>>> &pths);

private:
	const double INF = 1.79769e+308; //double MAX
	std::vector<std::vector<double>> g; //adjMatrix
	std::vector<std::vector<size_t>> mst; //adjMatrix
	
	std::vector<bool> component;

	void calc_component(int initial_vertex);

	bool isHoldingTriangleInequality();

	void get_euler_cycle_rec(const std::vector<std::vector<size_t>> &tree, size_t v, std::vector<size_t> &answer);
	std::vector<size_t> get_euler_cycle(const std::vector<std::vector<size_t>> &tree, size_t v);
	std::vector<bool> visited;

	bool isValidEdge(int u, int v, std::vector<bool> &inMST);
	void primMST();

};

