#pragma once

#define UNCLASSIFIED -1
#define CORE_POINT 1
#define BORDER_POINT 2
#define NOISE -2
#define SUCCESS 0
#define FAILURE -3

using namespace std;

class DBScan {
public:
	DBScan(UINT minPts, float eps, UINT min_clus_size, UINT max_clus_size, vector<CapturingReality::CoordinateSystemPoint> pts)
	{
		m_minPoints = minPts;
		m_epsilon = eps;
		min_cluster_size = min_clus_size;
		max_cluster_size = max_clus_size;
		points = pts;
		points_clusterId = vector<int>(pts.size(), UNCLASSIFIED);
	}

	int run();
	vector<int> calculateCluster(CapturingReality::CoordinateSystemPoint &point);
	int expandCluster(int idx, int clusterID);
	inline double calculateDistance(CapturingReality::CoordinateSystemPoint &pointCore, CapturingReality::CoordinateSystemPoint &pointTarget);

	int getTotalPointSize() { return m_pointSize; }
	int getMinimumClusterSize() { return m_minPoints; }
	int getEpsilonSize() { return m_epsilon; }

	vector<CapturingReality::CoordinateSystemPoint> points;
	vector<int> points_clusterId;
private:

	UINT min_cluster_size;
	UINT max_cluster_size;
	UINT m_pointSize;
	UINT m_minPoints;
	float m_epsilon;
};

