#include "stdafx.h"
#include "ControlPoints.h"

HRESULT CreateControlPoints( __deref_out IControlPoints **ppControlPoints )
{
	return ControlPoints::CreateInstance( ppControlPoints );
}

HRESULT AddMeasurement( __in IControlPoints *pControlPoints, __in UINT gcpIndex, __in UINT imageIndex, __in UINT imageWidth, __in UINT imageHeight, __in float x, __in float y )
{
	if ( pControlPoints == NULL )
	{
		return E_INVALIDARG;
	};

	ControlPoint *pCp; 
	HRESULT hr = pControlPoints->GetControlPoint( gcpIndex, &pCp );
	if ( SUCCEEDED( hr ) )
	{
		UINT mid = pCp->pTrack->measurementsCount;
		pCp->pTrack->measurements[mid].feature  = gcpIndex;
		pCp->pTrack->measurements[mid].image    = imageIndex;

		float scale = 1.0f / ( (float)max(imageWidth, imageHeight) );
		pCp->pTrack->measurements[mid].x = ( x - (float)(imageWidth)  * 0.5f ) * scale;
		pCp->pTrack->measurements[mid].y = ( y - (float)(imageHeight) * 0.5f ) * scale;
		pCp->pTrack->measurementsCount++;
	};

	return hr;
}

HRESULT ControlPoints::CreateInstance( __deref_out IControlPoints **ppControlPoints )
{
    if ( !ppControlPoints )
    {
        return E_POINTER;
    }

    ControlPoints *pObject = new ControlPoints();
    if ( !pObject )
    {
        return E_OUTOFMEMORY;
    }

    HRESULT hr = pObject->Initialize();
    if ( SUCCEEDED(hr) )
    {
        pObject->AddRef();
        *ppControlPoints = pObject;
    }
    else
    {
        delete pObject;
    }

    return hr;
}

ControlPoints::ControlPoints()
{
    m_RefCount = 0;
}

ControlPoints::~ControlPoints()
{
    _ASSERT( m_RefCount == 0 );
}

HRESULT ControlPoints::Initialize( )
{
	// a place for some work
	return S_OK;
}

HRESULT ControlPoints::SetControlPoint( __in_z const wchar_t *pszPointId, __in CoordinateSystemPoint *pPosition, __in_opt ICoordinateSystem *pCoordinateSystem )
{
	m_coordinateSystems.push_back( pCoordinateSystem );

	ControlPoint cp = {0};
	m_controlPoints.push_back( cp );

	CString name = pszPointId;
	m_controlPointNames.push_back( name );

	UINT controlPointIndex = (UINT)m_controlPoints.size()-1;

    ControlPoint *pCp = &m_controlPoints[controlPointIndex];

	HRESULT hr = m_tracks.AddNew( &pCp->pTrack );
	if ( SUCCEEDED( hr ) )
	{
		FillControlPointWithDefaultValues( pCp );

		pCp->calibrationType = ControlPointCalibrationType::CPCT_3D;
		pCp->csParams[0] = pPosition->x;
		pCp->csParams[1] = pPosition->y;
		pCp->csParams[2] = pPosition->z;
		pCp->id = controlPointIndex;
		CoCreateGuid( &pCp->identity );
		pCp->pTrack->pointId = controlPointIndex;
		pCp->pTrack->flag = TrackGlobalPointFlag::fActive;
		pCp->pTrack->color = 0;

	    pCp->pTrack->measurementsCount = 0;
	};

	return hr;
}

UINT ControlPoints::GetPointsCount()
{
	return (UINT)m_controlPoints.size();
}

HRESULT ControlPoints::GetControlPoint( __in UINT pointIndex, __out ControlPoint **ppPoint )
{
    if ( pointIndex >= GetPointsCount() )
    {
        return E_INVALIDARG;
    }
    else
    {
        *ppPoint = &m_controlPoints[pointIndex];
        return S_OK;
    }
}

HRESULT ControlPoints::GetControlPointCoordinateSystem( __in UINT pointIndex, __deref_out ICoordinateSystem **ppCoordinateSystem )
{
    return m_coordinateSystems[pointIndex].CopyTo( ppCoordinateSystem );
};

HRESULT ControlPoints::GetConstraintsCoordinateSystem( __in UINT constraintIndex, __deref_out ICoordinateSystem **ppCoordinateSystem )
{
    constraintIndex;
	return E_NOTIMPL;
}

const wchar_t* ControlPoints::GetControlPointName( __in UINT pointIndex )
{
	return m_controlPointNames[pointIndex].GetBuffer();
}

UINT ControlPoints::GetConstraintsCount()
{
    return 0;
}

int ControlPoints::FindPoint( __in UINT id )
{
	int cnt = (int)GetPointsCount();
    for ( int i = 0; i < cnt; i++ )
    {
        if ( m_controlPoints[i].id == id )
        {
            return i;
        }
    }
    return -1;
}

ControlPointConstraint *ControlPoints::GetConstraint( __in UINT index )
{
    index;
    return NULL;
}

HRESULT ControlPoints::RecalculatePoint( __in UINT pointIndex )
{
    pointIndex;
    return E_NOTIMPL;
}

void ControlPoints::Lock()
{
    //
}

void ControlPoints::Unlock()
{
    //
}

STDMETHODIMP ControlPoints::QueryInterface(REFIID riid, __deref_out_opt void **ppvObject)
{
    if ( riid == __uuidof(IControlPoints) )
    {
        *ppvObject = (void*)(IControlPoints*)this;
    }
    return E_NOTIMPL;
}

STDMETHODIMP_(ULONG) ControlPoints::AddRef()
{
    return InterlockedIncrement(&m_RefCount);
}

STDMETHODIMP_(ULONG) ControlPoints::Release()
{
    ULONG refCnt = InterlockedDecrement(&m_RefCount);
    if ( !refCnt )
    {
        delete this;
    }
    return refCnt;
}
