#pragma once

#include "Tracks.h"

using namespace CapturingReality::CoordinateSystems;
using namespace CapturingReality::Sfm;
using namespace CapturingReality;

class ControlPoints : public IControlPoints
{
private:

    std::vector< ControlPoint >	m_controlPoints;
    Tracks m_tracks;
	std::vector< CString > m_controlPointNames;
	std::vector< CComPtr< ICoordinateSystem > > m_coordinateSystems;

	// for CComObject interface 
	volatile LONG m_RefCount;

	static void FillControlPointTrackWithDefaultValues( __inout SfmReconstructionControlPoint *pTrack )
	{
		if ( !pTrack )
		{
			return;
		}

		pTrack->X.x = pTrack->X.y = pTrack->X.z = 0.0;
		pTrack->X.w = 1.0;
		pTrack->color = 0;
		pTrack->flag = 0;
		pTrack->measurementsCount = 0;
		pTrack->pointId = (UINT)-1;
	}

	static void FillControlPointWithDefaultValues( __inout ControlPoint *pPoint )
	{
		if ( !pPoint )
		{
			return;
		}

		FillControlPointTrackWithDefaultValues( pPoint->pTrack );

		pPoint->weight[ 0 ] = 10.; pPoint->weight[ 1 ] = 0.0; pPoint->weight[ 2 ] = 0.0;
		pPoint->weight[ 3 ] = 0.0; pPoint->weight[ 4 ] = 10.; pPoint->weight[ 5 ] = 0.0;
		pPoint->weight[ 6 ] = 0.0; pPoint->weight[ 7 ] = 0.0; pPoint->weight[ 8 ] = 10.;

		pPoint->id = (UINT)-1;
		pPoint->calibrationType = ControlPointCalibrationType::CPCT_2D;
		pPoint->csParams[ 0 ] = pPoint->csParams[ 1 ] = pPoint->csParams[ 2 ] = 0.0;
		pPoint->csParams[ 3 ] = pPoint->csParams[ 4 ] = pPoint->csParams[ 5 ] = 0.0;

		CoCreateGuid( &pPoint->identity );
	}


public:

	static HRESULT CreateInstance( __deref_out IControlPoints **ppControlPoints );

    ControlPoints();

    ~ControlPoints();

	HRESULT Initialize( );

	HRESULT AddMeasurement( __in UINT gcpIndex, __in UINT imageIndex, __in UINT imageWidth, __in UINT imageHeight, __in float x, __in float y );

    // IControlPoints

    HRESULT SetControlPoint( __in_z const wchar_t *pszPointId, __in CoordinateSystemPoint *pPosition, __in_opt ICoordinateSystem *pCoordinateSystem );

    UINT    GetPointsCount();

    HRESULT GetControlPoint( __in UINT pointIndex, __out ControlPoint **ppPoint );

    HRESULT GetControlPointCoordinateSystem( __in UINT pointIndex, __deref_out ICoordinateSystem **ppCoordinateSystem );

    HRESULT GetConstraintsCoordinateSystem( __in UINT constraintIndex, __deref_out ICoordinateSystem **ppCoordinateSystem );

    const wchar_t* GetControlPointName( __in UINT pointIndex );

    UINT    GetConstraintsCount();

    int     FindPoint( __in UINT id );

    ControlPointConstraint *GetConstraint( __in UINT index );

    HRESULT RecalculatePoint( __in UINT pointIndex );

    void    Lock();

    void    Unlock();

    // CComObject interface methods.

    STDMETHOD(QueryInterface)(REFIID riid, __deref_out_opt void **ppvObject);

    STDMETHOD_(ULONG, AddRef)();

    STDMETHOD_(ULONG, Release)();

};
